//-----------------------------------------------------------------------------
// Copyright  Micromega Corporation 2005-2007. All rights reserved.
//
// @file   fops.h
// @target Atmel AVR WinAVR compiler
//
// Defines uM-FPU V3 opcodes, matrix operations and FFT operations.
//
// @author Cam Thompson, Micromega Corporation
// @version
//     August 31, 2007
//    - updated for uM-FPU V3.1
//    November 17, 2006
//    - original version
//
//-----------------------------------------------------------------------------

//-------------------- uM-FPU V3.1 opcode definitions -------------------------

#constant SELECTA            0x01        // Select register A
#constant SELECTX            0x02        // Select register X
#constant CLR                0x03        // reg[nn] = 0
#constant CLRA            0x04        // reg[A] = 0
#constant CLRX            0x05        // reg[X] = 0, X = X + 1
#constant CLR0            0x06        // reg[0] = 0
#constant COPY            0x07        // reg[nn] = reg[mm]
#constant COPYA            0x08        // reg[nn] = reg[A]
#constant COPYX            0x09        // reg[nn] = reg[X], X = X + 1
#constant LOAD            0x0A        // reg[0] = reg[nn]
#constant LOADA            0x0B        // reg[0] = reg[A]
#constant LOADX            0x0C        // reg[0] = reg[X], X = X + 1
#constant ALOADX            0x0D        // reg[A] = reg[X], X = X + 1
#constant XSAVE            0x0E        // reg[X] = reg[nn], X = X + 1
#constant XSAVEA            0x0F        // reg[X] = reg[A], X = X + 1
#constant COPY0            0x10        // reg[nn] = reg[0]
#constant COPYI            0x11        // reg[nn] = long(unsigned bb)
#constant FPUSWAP            0x12        // Swap reg[nn] and reg[mm]
#constant SWAPA            0x13        // Swap reg[A] and reg[nn]
#constant LEFT            0x14        // Left parenthesis
#constant RIGHT            0x15        // Right parenthesis
#constant FWRITE            0x16        // Write 32-bit float to reg[nn]
#constant FWRITEA            0x17        // Write 32-bit float to reg[A]
#constant FWRITEX            0x18        // Write 32-bit float to reg[X], X = X + 1
#constant FWRITE0            0x19        // Write 32-bit float to reg[0]
#constant FREAD            0x1A        // Read 32-bit float from reg[nn]
#constant FREADA            0x1B        // Read 32-bit float from reg[A]
#constant FREADX            0x1C        // Read 32-bit float from reg[X], X = X + 1
#constant FREAD0            0x1D        // Read 32-bit float from reg[0]
#constant ATOF            0x1E        // Convert ASCII to float, store in reg[0]
#constant FTOA            0x1F        // Convert float to ASCII
#constant FSET            0x20        // reg[A] = reg[nn]
#constant FADD            0x21        // reg[A] = reg[A] + reg[nn]
#constant FSUB            0x22        // reg[A] = reg[A] - reg[nn]
#constant FSUBR            0x23        // reg[A] = reg[nn] - reg[A]
#constant FMUL            0x24        // reg[A] = reg[A] * reg[nn]
#constant FDIV            0x25        // reg[A] = reg[A] / reg[nn]
#constant FDIVR            0x26        // reg[A] = reg[nn] / reg[A]
#constant FPOW            0x27        // reg[A] = reg[A] ** reg[nn]
#constant FCMP            0x28        // Float compare reg[A] - reg[nn]
#constant FSET0            0x29        // reg[A] = reg[0]
#constant FADD0            0x2A        // reg[A] = reg[A] + reg[0]
#constant FSUB0            0x2B        // reg[A] = reg[A] - reg[0]
#constant FSUBR0            0x2C        // reg[A] = reg[0] - reg[A]
#constant FMUL0            0x2D        // reg[A] = reg[A] * reg[0]
#constant FDIV0            0x2E        // reg[A] = reg[A] / reg[0]
#constant FDIVR0            0x2F        // reg[A] = reg[0] / reg[A]
#constant FPOW0            0x30        // reg[A] = reg[A] ** reg[0]
#constant FCMP0            0x31        // Float compare reg[A] - reg[0]
#constant FSETI            0x32        // reg[A] = float(bb)
#constant FADDI            0x33        // reg[A] = reg[A] + float(bb)
#constant FSUBI            0x34        // reg[A] = reg[A] - float(bb)
#constant FSUBRI            0x35        // reg[A] = float(bb) - reg[A]
#constant FMULI            0x36        // reg[A] = reg[A] * float(bb)
#constant FDIVI            0x37        // reg[A] = reg[A] / float(bb)
#constant FDIVRI            0x38        // reg[A] = float(bb) / reg[A]
#constant FPOWI            0x39        // reg[A] = reg[A] ** bb
#constant FCMPI            0x3A        // Float compare reg[A] - float(bb)
#constant FSTATUS            0x3B        // Float status of reg[nn]
#constant FSTATUSA        0x3C        // Float status of reg[A]
#constant FCMP2            0x3D        // Float compare reg[nn] - reg[mm]
#constant FNEG            0x3E        // reg[A] = -reg[A]
#constant FABS            0x3F        // reg[A] = | reg[A] |
#constant FINV            0x40        // reg[A] = 1 / reg[A]
#constant FPUSQRT            0x41        // reg[A] = sqrt(reg[A])
#constant ROOT            0x42        // reg[A] = root(reg[A], reg[nn])
#constant LOG                0x43        // reg[A] = log(reg[A])
#constant LOG10            0x44        // reg[A] = log10(reg[A])
#constant EXP                0x45        // reg[A] = exp(reg[A])
#constant EXP10            0x46        // reg[A] = exp10(reg[A])
#constant FPUSIN                0x47        // reg[A] = sin(reg[A])
#constant FPUCOS                0x48        // reg[A] = cos(reg[A])
#constant FPUTAN                0x49        // reg[A] = tan(reg[A])
#constant ASIN            0x4A        // reg[A] = asin(reg[A])
#constant ACOS            0x4B        // reg[A] = acos(reg[A])
#constant ATAN            0x4C        // reg[A] = atan(reg[A])
#constant ATAN2            0x4D        // reg[A] = atan2(reg[A], reg[nn])
#constant DEGREES            0x4E        // reg[A] = degrees(reg[A])
#constant RADIANS            0x4F        // reg[A] = radians(reg[A])
#constant FMOD            0x50        // reg[A] = reg[A] MOD reg[nn]
#constant FLOOR            0x51        // reg[A] = floor(reg[A])
#constant CEIL            0x52        // reg[A] = ceil(reg[A])
#constant ROUND            0x53        // reg[A] = round(reg[A])
#constant FMIN            0x54        // reg[A] = min(reg[A], reg[nn])
#constant FMAX            0x55        // reg[A] = max(reg[A], reg[nn])
#constant FCNV            0x56        // reg[A] = conversion(nn, reg[A])
#constant FMAC            0x57        // reg[A] = reg[A] + (reg[nn] * reg[mm])
#constant FMSC            0x58        // reg[A] = reg[A] - (reg[nn] * reg[mm])
#constant LOADBYTE        0x59        // reg[0] = float(signed bb)
#constant LOADUBYTE        0x5A        // reg[0] = float(unsigned byte)
#constant LOADWORD        0x5B        // reg[0] = float(signed word)
#constant LOADUWORD        0x5C        // reg[0] = float(unsigned word)
#constant LOADE            0x5D        // reg[0] = 2.7182818
#constant LOADPI            0x5E        // reg[0] = 3.1415927
#constant LOADCON            0x5F        // reg[0] = float constant(nn)
#constant FPUFLOAT            0x60        // reg[A] = float(reg[A])
#constant FIX                0x61        // reg[A] = fix(reg[A])
#constant FIXR            0x62        // reg[A] = fix(round(reg[A]))
#constant FRAC            0x63        // reg[A] = fraction(reg[A])
#constant FSPLIT            0x64        // reg[A] = int(reg[A]), reg[0] = frac(reg[A])
#constant SELECTMA        0x65        // Select matrix A
#constant SELECTMB        0x66        // Select matrix B
#constant SELECTMC        0x67        // Select matrix C
#constant LOADMA            0x68        // reg[0] = matrix A[bb,bb]
#constant LOADMB            0x69        // reg[0] = matrix B[bb, bb]
#constant LOADMC            0x6A        // reg[0] = matrix C[bb, bb]
#constant SAVEMA            0x6B        // matrix A[bb,bb] = reg[A]
#constant SAVEMB            0x6C        // matrix B[bb,bb] = reg[A]
#constant SAVEMC            0x6D        // matrix C[bb,bb] = reg[A]
#constant MOP                0x6E        // Matrix operation
#constant FFT                0x6F        // FFT operation
#constant WRBLK            0x70        // write register block
#constant RDBLK            0x71        // read register block
#constant LOADIND            0x7A        // reg[0] = reg[reg[nn]]
#constant SAVEIND            0x7B        // reg[reg[nn]] = reg[A]
#constant INDA            0x7C        // Select A using reg[nn]
#constant INDX            0x7D        // Select X using reg[nn]
#constant FCALL            0x7E        // Call function in Flash memory
#constant EECALL            0x7F        // Call function in EEPROM memory
#constant RET                0x80        // Return from function
#constant BRA                0x81        // Unconditional branch
#constant BRACC            0x82        // Conditional branch
#constant JMP                0x83        // Unconditional jump
#constant JMPCC            0x84        // Conditional jump
#constant TABLE            0x85        // Table lookup
#constant FTABLE            0x86        // Floating point reverse table lookup
#constant LTABLE            0x87        // Long integer reverse table lookup
#constant POLY            0x88        // reg[A] = nth order polynomial
#constant FPUGOTO            0x89        // Computed goto
#constant RETCC            0x8A        // Conditional return from function
#constant LWRITE            0x90        // Write 32-bit long integer to reg[nn]
#constant LWRITEA            0x91        // Write 32-bit long integer to reg[A]
#constant LWRITEX            0x92        // Write 32-bit long integer to reg[X], X = X + 1
#constant LWRITE0            0x93        // Write 32-bit long integer to reg[0]
#constant LREAD            0x94        // Read 32-bit long integer from reg[nn]
#constant LREADA            0x95        // Read 32-bit long integer from reg[A]
#constant LREADX            0x96        // Read 32-bit long integer from reg[X], X = X + 1
#constant LREAD0            0x97        // Read 32-bit long integer from reg[0]
#constant LREADBYTE        0x98        // Read lower 8 bits of reg[A]
#constant LREADWORD        0x99        // Read lower 16 bits reg[A]
#constant ATOL            0x9A        // Convert ASCII to long integer
#constant LTOA            0x9B        // Convert long integer to ASCII
#constant LSET            0x9C        // reg[A] = reg[nn]
#constant LADD            0x9D        // reg[A] = reg[A] + reg[nn]
#constant LSUB            0x9E        // reg[A] = reg[A] - reg[nn]
#constant LMUL            0x9F        // reg[A] = reg[A] * reg[nn]
#constant LDIV            0xA0        // reg[A] = reg[A] / reg[nn]
#constant LCMP            0xA1        // Signed long compare reg[A] - reg[nn]
#constant LUDIV            0xA2        // reg[A] = reg[A] / reg[nn]
#constant LUCMP            0xA3        // Unsigned long compare of reg[A] - reg[nn]
#constant LTST            0xA4        // Long integer status of reg[A] AND reg[nn]
#constant LSET0            0xA5        // reg[A] = reg[0]
#constant LADD0            0xA6        // reg[A] = reg[A] + reg[0]
#constant LSUB0            0xA7        // reg[A] = reg[A] - reg[0]
#constant LMUL0            0xA8        // reg[A] = reg[A] * reg[0]
#constant LDIV0            0xA9        // reg[A] = reg[A] / reg[0]
#constant LCMP0            0xAA        // Signed long compare reg[A] - reg[0]
#constant LUDIV0            0xAB        // reg[A] = reg[A] / reg[0]
#constant LUCMP0            0xAC        // Unsigned long compare reg[A] - reg[0]
#constant LTST0            0xAD        // Long integer status of reg[A] AND reg[0]
#constant LSETI            0xAE        // reg[A] = long(bb)
#constant LADDI            0xAF        // reg[A] = reg[A] + long(bb)
#constant LSUBI            0xB0        // reg[A] = reg[A] - long(bb)
#constant LMULI            0xB1        // reg[A] = reg[A] * long(bb)
#constant LDIVI            0xB2        // reg[A] = reg[A] / long(bb)
#constant LCMPI            0xB3        // Signed long compare reg[A] - long(bb)
#constant LUDIVI            0xB4        // reg[A] = reg[A] / unsigned long(bb)
#constant LUCMPI            0xB5        // Unsigned long compare reg[A] - ulong(bb)
#constant LTSTI            0xB6        // Long integer status of reg[A] AND ulong(bb)
#constant LSTATUS            0xB7        // Long integer status of reg[nn]
#constant LSTATUSA        0xB8        // Long integer status of reg[A]
#constant LCMP2            0xB9        // Signed long compare reg[nn] - reg[mm]
#constant LUCMP2            0xBA        // Unsigned long compare reg[nn] - reg[mm]
#constant LNEG            0xBB        // reg[A] = -reg[A]
#constant LABS            0xBC        // reg[A] = | reg[A] |
#constant LINC            0xBD        // reg[nn] = reg[nn] + 1
#constant LDEC            0xBE        // reg[nn] = reg[nn] - 1
#constant LNOT            0xBF        // reg[A] = NOT reg[A]
#constant LAND            0xC0        // reg[A] = reg[A] AND reg[nn]
#constant LOR                0xC1        // reg[A] = reg[A] OR reg[nn]
#constant LXOR            0xC2        // reg[A] = reg[A] XOR reg[nn]
#constant LSHIFT            0xC3        // reg[A] = reg[A] shift reg[nn]
#constant LMIN            0xC4        // reg[A] = min(reg[A], reg[nn])
#constant LMAX            0xC5        // reg[A] = max(reg[A], reg[nn])
#constant LONGBYTE        0xC6        // reg[0] = long(signed byte bb)
#constant LONGUBYTE        0xC7        // reg[0] = long(unsigned byte bb)
#constant LONGWORD        0xC8        // reg[0] = long(signed word wwww)
#constant LONGUWORD        0xC9        // reg[0] = long(unsigned word wwww)
#constant SETSTATUS        0xCD        // Set status byte
#constant FPUSEROUT            0xCE        // Serial output
#constant FPUSERIN            0xCF        // Serial Input
#constant SETOUT            0xD0        // Set OUT1 and OUT2 output pins
#constant ADCMODE            0xD1        // Set A/D trigger mode
#constant ADCTRIG            0xD2        // A/D manual trigger
#constant ADCSCALE        0xD3        // ADCscale[ch] = B
#constant ADCLONG            0xD4        // reg[0] = ADCvalue[ch]
#constant ADCLOAD            0xD5        // reg[0] = float(ADCvalue[ch]) * ADCscale[ch]
#constant ADCWAIT            0xD6        // wait for next A/D sample
#constant TIMESET            0xD7        // time = reg[0]
#constant TIMELONG        0xD8        // reg[0] = time (long)
#constant TICKLONG        0xD9        // reg[0] = ticks (long)
#constant EESAVEF            0xDA        // EEPROM[nn] = reg[mm]
#constant EESAVEA            0xDB        // EEPROM[nn] = reg[A]
#constant RTC             0xDC        // RTC with Action
#constant EELODA            0xDD        // reg[A] = EEPROM[nn]
#constant EEWRITE            0xDE        // Store bytes in EEPROM
#constant EXTSET            0xE0        // external input count = reg[0]
#constant EXTLONG            0xE1        // reg[0] = external input counter (long)
#constant EXTWAIT            0xE2        // wait for next external input
#constant STRSET            0xE3        // Copy string to string buffer
#constant STRSEL            0xE4        // Set selection point
#constant STRINS            0xE5        // Insert string at selection point
#constant STRCMP            0xE6        // Compare string with string buffer
#constant STRFIND            0xE7        // Find string and set selection point
#constant STRFCHR            0xE8        // Set field separators
#constant STRFIELD        0xE9        // Find field and set selection point
#constant STRTOF            0xEA        // Convert string selection to float
#constant STRTOL            0xEB        // Convert string selection to long
#constant READSEL            0xEC        // Read string selection
#constant STRBYTE            0xED        // Insert 8-bit byte at selection point
#constant STRINC            0xEE        // increment selection point
#constant STRDEC            0xEF        // decrement selection point
#constant SYNC            0xF0        // Get synchronization byte
#constant READSTATUS        0xF1        // Read status byte
#constant READSTR            0xF2        // Read string from string buffer
#constant VERSION            0xF3        // Copy version string to string buffer
#constant IEEEMODE        0xF4        // Set IEEE mode (default)
#constant PICMODE            0xF5        // Set PIC mode
#constant CHECKSUM        0xF6        // Calculate checksum for uM-FPU code
#constant FPUBREAK            0xF7        // Debug breakpoint
#constant TRACEOFF        0xF8        // Turn debug trace off
#constant TRACEON            0xF9        // Turn debug trace on
#constant TRACESTR        0xFA        // Send string to debug trace buffer
#constant TRACEREG        0xFB        // Send register value to trace buffer
#constant READVAR            0xFC        // Read internal variable, store in reg[0]

#constant SYNC_CHAR        0x5C        // sync character

//-------------------- uM-FPU V3 MOP definitions ------------------------------

#constant SCALAR_SET        0        // MA[row,col] = reg[0], for all elements
#constant SCALAR_ADD        1        // MA[row,col] = MA[row,col] + reg[0], for all elements
#constant SCALAR_SUB        2        // MA[row,col] = reg[0] - MA[row,col], for all elements
#constant SCALAR_SUBR        3        // MA[row,col] = MA[row,col] + reg[0], for all elements
#constant SCALAR_MUL        4        // MA[row,col] = MA[row,col] * reg[0], for all elements
#constant SCALAR_DIV        5        // MA[row,col] = MA[row,col] / reg[0], for all elements
#constant SCALAR_DIVR        6        // MA[row,col] = reg[0] / MA[row,col], for all elements
#constant SCALAR_POW        7        //  MA[row,col] = MA[row,col] ** reg[0], for all elements
#constant EWISE_SET        8        // MA[row,col] = MB[row,col], for all elements
#constant EWISE_ADD        9        // MA[row,col] = MA[row,col] + MB[row,col], for all elements
#constant EWISE_SUB        10        // MA[row,col] = MB[row,col] - MA[row,col], for all elements
#constant EWISE_SUBR        11        // MA[row,col] = MA[row,col] + MB[row,col], for all elements
#constant EWISE_MUL        12        // MA[row,col] = MA[row,col] * MB[row,col], for all elements
#constant EWISE_DIV        13        // MA[row,col] = MA[row,col] / MB[row,col], for all elements
#constant EWISE_DIVR        14        // MA[row,col] = MB[row,col] / MA[row,col], for all elements
#constant EWISE_POW        15        // MA[row,col] = MA[row,col] ** MB[row,col], for all elements
#constant MX_MULTIPLY        16        // MA = MB * MC matrix multiply
#constant MX_IDENTITY        17        // MA = identity matrix
#constant MX_DIAGONAL        18        // MA = diagonal matrix
#constant MX_TRANSPOSE    19        // MA = transpose of MB
#constant MX_COUNT        20        // reg[0] = number of elements in MA
#constant MX_SUM            21        // reg[0] = sum of all elements in MA
#constant MX_AVE            22        // reg[0] = average value of all elements in MA
#constant MX_MIN            23        // reg[0] = minimum value of all elements in MA
#constant MX_MAX            24        // reg[0] = maximum value of all elements in MA
#constant MX_COPYAB        25        // copy MA to MC
#constant MX_COPYAC        26        // copy MA to MC
#constant MX_COPYBA        27        // copy MB to MA
#constant MX_COPYBC        28        // copy MB to MC
#constant MX_COPYCA        29        // copy MC to MA
#constant MX_COPYCB        30        // copy MC to MB
#constant MX_DETERM        31        // reg0 = determinant of MA (2x2 and 3x3)
#constant MX_INVERSE        32        // MA = inverse of MB (2x2 and 3x3)
#constant MX_ILOADRA        33        // indexed load registers to MA
#constant MX_ILOADRB        34        // indexed load registers to MB
#constant MX_ILOADRC        35        // indexed load registers to MC
#constant MX_ILOADBA        36        // indexed load MB to MA
#constant MX_ILOADCA        37        // indexed load MC to MA
#constant MX_ISAVEAR        38        // indexed save MA to registers
#constant MX_ISAVEAB        39        // indexed save MA to MB
#constant MX_ISAVEAC        40        // indexed save MA to MC


//-------------------- uM-FPU V3 FFT definitions ------------------------------

#constant FIRST_STAGE          0        // first stage of FFT
#constant NEXT_STAGE           1        // next stage of FFT
#constant NEXT_LEVEL          2        // next level of FFT
#constant NEXT_BLOCK          3        // next block of FFT
#constant BIT_REVERSE           4        // bit reverse sort (pre-processing)
#constant PRE_ADJUST          8        // inverse FFT (pre-processing)
#constant POST_ADJUST           16        // inverse FFT (post-processing)

//---------------------uFPU-64 RTC actions-------------------------------------

#constant INIT            0        // set RTC mode
#constant START            0x10    // start RTC
#constant STOP            0x20    // stop RTC
#constant ALARM_MASK        0x30    // set the alarm mask
#constant WRITE_TIME        0x40    // Write RTC date and time value
#constant WRITE_ALARM        0x50    // Write alarm data and time value
#constant READ_TIME        0x60    // read RTC date and time value
#constant READ_ALARM        0x70    // read alarm data and time value
#constant FPUSTR                0x08    // date-tine is a string
#constant NO_STR            0x00    // use value in reg 0
#constant DATE_TIME        0x00    // unix time number
#constant SECOND            0x01    // seconds number 0-59 string 0-59
#constant MINUTE            0x02    // minutes number 0-59 string 0-59
#constant HOUR            0x03    // hours number 0-23 string 0-23
#constant DAY                0x04    // days number 1-31 string 1-31
#constant MONTH            0x05    // months number 1-12 string 1-12
#constant YEAR            0x06    // year number 0-99 string 2000-2099
#constant WEEKDAY            0x07    // day of week number 0-6 string 0-6

//---------------------uFPU-64 op-codes---------------------------------------

#constant DWRITE            0x72    // load a register with a 64 bit value

